package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpIpNetIpLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;

/**
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@Configuration
@EnableConfigurationProperties(IpLibraryConfiguration.class)
public class IpLibraryAutoConfiguration {

    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean("baiduIpLibrary")
    public BaiduIpLibrary baiduIpLibrary() {
        return new BaiduIpLibrary();
    }

    @Bean(name = "ipIpNetIpLibrary", initMethod = "init", destroyMethod = "destroy")
    public IpIpNetIpLibrary ipIpNetIpLibrary() {
        try {
            return new IpIpNetIpLibrary(new ClassPathResource(configuration.getIpipNetFilePath()).getInputStream());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean("ipLibraries")
    public IpLibraries ipLibraries() {
        return new IpLibraries(ipIpNetIpLibrary(), baiduIpLibrary());
    }
}
