package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpipNetForDbIpLibrary;
import com.bxm.warcar.ip.impl.Ipplus360IpLibrary;
import com.bxm.warcar.utils.file.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.io.File;

/**
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@Configuration
@EnableConfigurationProperties(IpLibraryConfiguration.class)
public class IpLibraryAutoConfiguration {

    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean("baiduIpLibrary")
    public BaiduIpLibrary baiduIpLibrary() {
        return new BaiduIpLibrary();
    }

    @Primary
    @Bean(name = "ipIpNetIpLibrary", initMethod = "init", destroyMethod = "destroy")
    public IpipNetForDbIpLibrary ipIpNetIpLibrary() {
        if (!configuration.isIpipNetEnable()) {
            return null;
        }
        if (StringUtils.equals(configuration.getIpipNetUseType(), IpLibraryConfiguration.USE_TYPE_REMOTE)) {

            FileComparator fileComparator = SystemFileComparatorFactory.create()
                    .fingerprintTracker(new SimpleFingerprintTracker(configuration.getIpipNetFingerprintUrl(), "ipipnet.fingerprint"))
                    .dataTracker(new SimpleDataTracker(configuration.getIpipNetDataUrl(), "ipipnet.data"))
                    .build();

            final IpipNetForDbIpLibrary library = new IpipNetForDbIpLibrary(fileComparator.getData().getPath());

            FileMonitor fileMonitor = new SystemFileMonitor(fileComparator);
            fileMonitor.addListener(library::refresh);
            fileMonitor.start();

            return library;
        }
        if (StringUtils.equals(configuration.getIpipNetUseType(), IpLibraryConfiguration.USE_TYPE_LOCALFILE)) {
            return new IpipNetForDbIpLibrary(configuration.getIpipNetFilePath());
        }
        return null;
    }

    @Bean(name = "ipplus360IpLibrary", initMethod = "init", destroyMethod = "destroy")
    public Ipplus360IpLibrary ipplus360IpLibrary() {
        if (!configuration.isIpplus360Enable()) {
            return null;
        }
        if (StringUtils.equals(configuration.getIpplus360UseType(), IpLibraryConfiguration.USE_TYPE_REMOTE)) {
            FileComparator fileComparator = SystemFileComparatorFactory.create()
                    .fingerprintTracker(new SimpleFingerprintTracker(configuration.getIpplus360FingerprintUrl(), "ipplus360.fingerprint"))
                    .dataTracker(new SimpleDataTracker(configuration.getIpplus360DataUrl(), "ipplus360.dat"))
                    .build();
            final Ipplus360IpLibrary library = new Ipplus360IpLibrary(fileComparator.getData());

            FileMonitor fileMonitor = new SystemFileMonitor(fileComparator);
            fileMonitor.addListener(library::refresh);
            fileMonitor.start();

            return library;
        }
        if (StringUtils.equals(configuration.getIpplus360UseType(), IpLibraryConfiguration.USE_TYPE_LOCALFILE)) {
            return new Ipplus360IpLibrary(new File(configuration.getIpplus360FilePath()));
        }
        return null;
    }

    @Bean("ipLibraries")
    public IpLibraries ipLibraries() {
        return new IpLibraries(ipIpNetIpLibrary(), baiduIpLibrary());
    }
}
