package com.bxm.warcar.ip.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@ConfigurationProperties(prefix = "warcar.ip")
public class IpLibraryConfiguration {

    public static final String USE_TYPE_REMOTE = "remote";
    public static final String USE_TYPE_LOCALFILE = "localfile";

    private boolean ipipNetEnable = false;
    private String ipipNetFingerprintUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.fingerprint";
    private String ipipNetDataUrl = "https://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.ipdb";
    private String ipipNetFilePath = "ipipnet.ipdb";
    private String ipipNetUseType = USE_TYPE_REMOTE;

    private boolean ipplus360Enable = false;
    private String ipplus360FingerprintUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipplus360.fingerprint";
    private String ipplus360DataUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipplus360.dat";
    private String ipplus360FilePath = "ipplus360.dat";
    private String ipplus360UseType = USE_TYPE_REMOTE;

    private boolean aliyunEnable = true;
    private String aliyunFingerprintUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/aliyun/ipv4-testonly.ft";
    private String aliyunDataUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/aliyun/ipv4-testonly.dex";
    private String aliyunLicenseUrl = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/aliyun/ipv4-testonly.lic";
    private String aliyunFilePath = "aliyun.dex";
    private String aliyunLicenseFilePath = "aliyun.lic";
    private String aliyunUseType = USE_TYPE_REMOTE;

    public boolean isIpipNetEnable() {
        return ipipNetEnable;
    }

    public void setIpipNetEnable(boolean ipipNetEnable) {
        this.ipipNetEnable = ipipNetEnable;
    }

    public String getIpipNetFilePath() {
        return ipipNetFilePath;
    }

    public void setIpipNetFilePath(String ipipNetFilePath) {
        this.ipipNetFilePath = ipipNetFilePath;
    }

    public String getIpipNetFingerprintUrl() {
        return ipipNetFingerprintUrl;
    }

    public void setIpipNetFingerprintUrl(String ipipNetFingerprintUrl) {
        this.ipipNetFingerprintUrl = ipipNetFingerprintUrl;
    }

    public String getIpipNetDataUrl() {
        return ipipNetDataUrl;
    }

    public void setIpipNetDataUrl(String ipipNetDataUrl) {
        this.ipipNetDataUrl = ipipNetDataUrl;
    }

    public String getIpipNetUseType() {
        return ipipNetUseType;
    }

    public void setIpipNetUseType(String ipipNetUseType) {
        this.ipipNetUseType = ipipNetUseType;
    }

    public boolean isIpplus360Enable() {
        return ipplus360Enable;
    }

    public void setIpplus360Enable(boolean ipplus360Enable) {
        this.ipplus360Enable = ipplus360Enable;
    }

    public String getIpplus360FingerprintUrl() {
        return ipplus360FingerprintUrl;
    }

    public void setIpplus360FingerprintUrl(String ipplus360FingerprintUrl) {
        this.ipplus360FingerprintUrl = ipplus360FingerprintUrl;
    }

    public String getIpplus360DataUrl() {
        return ipplus360DataUrl;
    }

    public void setIpplus360DataUrl(String ipplus360DataUrl) {
        this.ipplus360DataUrl = ipplus360DataUrl;
    }

    public String getIpplus360FilePath() {
        return ipplus360FilePath;
    }

    public void setIpplus360FilePath(String ipplus360FilePath) {
        this.ipplus360FilePath = ipplus360FilePath;
    }

    public String getIpplus360UseType() {
        return ipplus360UseType;
    }

    public void setIpplus360UseType(String ipplus360UseType) {
        this.ipplus360UseType = ipplus360UseType;
    }

    public boolean isAliyunEnable() {
        return aliyunEnable;
    }

    public void setAliyunEnable(boolean aliyunEnable) {
        this.aliyunEnable = aliyunEnable;
    }

    public String getAliyunFingerprintUrl() {
        return aliyunFingerprintUrl;
    }

    public void setAliyunFingerprintUrl(String aliyunFingerprintUrl) {
        this.aliyunFingerprintUrl = aliyunFingerprintUrl;
    }

    public String getAliyunDataUrl() {
        return aliyunDataUrl;
    }

    public void setAliyunDataUrl(String aliyunDataUrl) {
        this.aliyunDataUrl = aliyunDataUrl;
    }

    public String getAliyunFilePath() {
        return aliyunFilePath;
    }

    public void setAliyunFilePath(String aliyunFilePath) {
        this.aliyunFilePath = aliyunFilePath;
    }

    public String getAliyunLicenseFilePath() {
        return aliyunLicenseFilePath;
    }

    public void setAliyunLicenseFilePath(String aliyunLicenseFilePath) {
        this.aliyunLicenseFilePath = aliyunLicenseFilePath;
    }

    public String getAliyunLicenseUrl() {
        return aliyunLicenseUrl;
    }

    public void setAliyunLicenseUrl(String aliyunLicenseUrl) {
        this.aliyunLicenseUrl = aliyunLicenseUrl;
    }

    public String getAliyunUseType() {
        return aliyunUseType;
    }

    public void setAliyunUseType(String aliyunUseType) {
        this.aliyunUseType = aliyunUseType;
    }
}
