/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.autoconfigure.IpLibraries;
import com.bxm.warcar.ip.autoconfigure.IpLibraryConfiguration;
import com.bxm.warcar.ip.impl.AliyunIpLibrary;
import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpipNetForDbIpLibrary;
import com.bxm.warcar.ip.impl.Ipplus360IpLibrary;
import com.bxm.warcar.ip.impl.aliyun.GeoipProfile;
import com.bxm.warcar.utils.file.DataTracker;
import com.bxm.warcar.utils.file.FileComparator;
import com.bxm.warcar.utils.file.FingerprintTracker;
import com.bxm.warcar.utils.file.SimpleDataTracker;
import com.bxm.warcar.utils.file.SimpleFingerprintTracker;
import com.bxm.warcar.utils.file.SystemFileComparator;
import com.bxm.warcar.utils.file.SystemFileComparatorFactory;
import com.bxm.warcar.utils.file.SystemFileMonitor;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={IpLibraryConfiguration.class})
public class IpLibraryAutoConfiguration {
    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean(value={"baiduIpLibrary"})
    public BaiduIpLibrary baiduIpLibrary() {
        if (!this.configuration.isBaiduEnable()) {
            return null;
        }
        return new BaiduIpLibrary();
    }

    @Bean(name={"aliyunIpLibrary"}, initMethod="init", destroyMethod="destroy")
    public AliyunIpLibrary aliyunIpLibrary() {
        if (!this.configuration.isAliyunEnable()) {
            return null;
        }
        GeoipProfile profile = new GeoipProfile(this.configuration.getAliyunRegionId(), this.configuration.getAliyunAccessKeyId(), this.configuration.getAliyunSecret(), this.configuration.getAliyunInstanceId());
        profile.setAutoUpgrade(this.configuration.isAliyunAutoUpgrade());
        return new AliyunIpLibrary(profile);
    }

    @Bean(name={"ipIpNetIpLibrary"}, initMethod="init", destroyMethod="destroy")
    public IpipNetForDbIpLibrary ipIpNetIpLibrary() {
        if (!this.configuration.isIpipNetEnable()) {
            return null;
        }
        if (StringUtils.equals((String)this.configuration.getIpipNetUseType(), (String)"remote")) {
            SystemFileComparator fileComparator = SystemFileComparatorFactory.create().fingerprintTracker((FingerprintTracker)new SimpleFingerprintTracker(this.configuration.getIpipNetFingerprintUrl(), "ipipnet.fingerprint")).dataTracker((DataTracker)new SimpleDataTracker(this.configuration.getIpipNetDataUrl(), "ipipnet.data")).build();
            IpipNetForDbIpLibrary library = new IpipNetForDbIpLibrary(fileComparator.getData().getPath());
            SystemFileMonitor fileMonitor = new SystemFileMonitor((FileComparator)fileComparator);
            fileMonitor.addListener(() -> ((IpipNetForDbIpLibrary)library).refresh());
            fileMonitor.start();
            return library;
        }
        if (StringUtils.equals((String)this.configuration.getIpipNetUseType(), (String)"localfile")) {
            return new IpipNetForDbIpLibrary(this.configuration.getIpipNetFilePath());
        }
        return null;
    }

    @Bean(name={"ipplus360IpLibrary"}, initMethod="init", destroyMethod="destroy")
    public Ipplus360IpLibrary ipplus360IpLibrary() {
        if (!this.configuration.isIpplus360Enable()) {
            return null;
        }
        if (StringUtils.equals((String)this.configuration.getIpplus360UseType(), (String)"remote")) {
            SystemFileComparator fileComparator = SystemFileComparatorFactory.create().fingerprintTracker((FingerprintTracker)new SimpleFingerprintTracker(this.configuration.getIpplus360FingerprintUrl(), "ipplus360.fingerprint")).dataTracker((DataTracker)new SimpleDataTracker(this.configuration.getIpplus360DataUrl(), "ipplus360.dat")).build();
            Ipplus360IpLibrary library = new Ipplus360IpLibrary(fileComparator.getData());
            SystemFileMonitor fileMonitor = new SystemFileMonitor((FileComparator)fileComparator);
            fileMonitor.addListener(() -> ((Ipplus360IpLibrary)library).refresh());
            fileMonitor.start();
            return library;
        }
        if (StringUtils.equals((String)this.configuration.getIpplus360UseType(), (String)"localfile")) {
            return new Ipplus360IpLibrary(new File(this.configuration.getIpplus360FilePath()));
        }
        return null;
    }

    @Primary
    @Bean(value={"ipLibraries"})
    public IpLibraries ipLibraries(ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(IpLibrary.class);
        return new IpLibraries(beans.values().toArray(new IpLibrary[0]));
    }
}

