package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.google.common.collect.Lists;
import org.springframework.core.Ordered;

import java.util.*;

/**
 * @author allen
 * @since V1.0.0 2017/12/14
 */
public class IpLibraries implements IpLibrary {

    private final List<IpLibrary> libraries = Lists.newArrayList();

    public IpLibraries(IpLibrary...librarys) {
        this.libraries.addAll(Lists.newArrayList(librarys));
        this.libraries.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }

    @Override
    public IP find(String ip) {
        for (IpLibrary library : libraries) {
            if (library.equals(this)) {
                continue;
            }
            IP rst = library.find(ip);
            if (null != rst && rst.isHit()) {
                return rst;
            }
        }
        return null;
    }

    @Override
    public void refresh() {
    }
}
