package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.MatchedIpLibrary;
import com.bxm.warcar.ip.impl.SetMatchedIpLibrary;
import com.google.common.collect.Lists;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
@EnableConfigurationProperties(MatchedIpLibraryConfiguration.class)
public class MatchedIpLibraryAutoConfiguration implements ApplicationContextAware {

    private final MatchedIpLibraryConfiguration configuration;
    private ApplicationContext applicationContext;

    public MatchedIpLibraryAutoConfiguration(MatchedIpLibraryConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public MatchedIpLibrary matchedIpLibrary() throws ClassNotFoundException {
        String[] classes = configuration.getClasses();
        if (ArrayUtils.isEmpty(classes)) {
            return null;
        }

        List<IpLibrary> libraries = Lists.newArrayList();
        for (String cls : classes) {
            Object bean = applicationContext.getBean(Class.forName(cls));
            if (null == bean) {
                throw new RuntimeException("Cannot be found class " + cls + " of the application context!");
            }
            if (!(bean instanceof IpLibrary)) {
                throw new RuntimeException("class " + cls + " must be instance of IpLibrary!");
            }
            libraries.add((IpLibrary) bean);
        }
        return new SetMatchedIpLibrary(libraries);
    }
}
