/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.jmx.autoconfigure;

import com.bxm.warcar.jmx.autoconfigure.ConditionalOnEnabled;
import com.bxm.warcar.jmx.autoconfigure.JmxConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jmx.support.ConnectorServerFactoryBean;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

@Configuration
@EnableConfigurationProperties(value={JmxConfiguration.class})
public class JmxAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxAutoConfiguration.class);
    @Autowired
    private JmxConfiguration configuration;

    @Bean
    @ConditionalOnEnabled
    public RmiRegistryFactoryBean rmiRegistryFactoryBean() {
        RmiRegistryFactoryBean factoryBean = new RmiRegistryFactoryBean();
        factoryBean.setPort(this.configuration.getPort());
        return factoryBean;
    }

    @Bean
    @ConditionalOnEnabled
    public ConnectorServerFactoryBean connectorServerFactoryBean() {
        ConnectorServerFactoryBean factoryBean = new ConnectorServerFactoryBean();
        String url = this.configuration.getUrl();
        factoryBean.setServiceUrl(url);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("JMX connector server started: {}", (Object)url);
        }
        return this.configuration.isEnabled() ? factoryBean : null;
    }
}

