/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.jmx.autoconfigure.jmxmp;

import com.bxm.warcar.jmx.autoconfigure.ConditionalOnEnabled;
import com.bxm.warcar.jmx.autoconfigure.JmxConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jmx.support.ConnectorServerFactoryBean;

@ConditionalOnEnabled
@ConditionalOnProperty(name={"warcar.jmx.protocol"}, havingValue="jmxmp")
@EnableConfigurationProperties(value={JmxConfiguration.class})
public class JmxmpAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxmpAutoConfiguration.class);
    @Autowired
    private JmxConfiguration configuration;

    @Bean
    public ConnectorServerFactoryBean connectorServerFactoryBean() {
        ConnectorServerFactoryBean factoryBean = new ConnectorServerFactoryBean();
        String url = this.getUrl();
        factoryBean.setServiceUrl(url);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("JMX(jmxmp) connector server started: {}", (Object)url);
        }
        return factoryBean;
    }

    private String getUrl() {
        String host = this.configuration.getHost();
        int port = this.configuration.getPort();
        return "service:jmx:jmxmp://" + host + ":" + port;
    }
}

