package com.bxm.warcar.jmx.autoconfigure.rmi;

import com.bxm.warcar.jmx.autoconfigure.ConditionalOnEnabled;
import com.bxm.warcar.jmx.autoconfigure.JmxConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jmx.support.ConnectorServerFactoryBean;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@ConditionalOnEnabled
@ConditionalOnProperty(name = JmxConfiguration.PROTOCOL, havingValue = "rmi")
@EnableConfigurationProperties(JmxConfiguration.class)
public class JmxrmiAutoConfiguration {

    private static final Logger LOGGER = LoggerFactory.getLogger(JmxrmiAutoConfiguration.class);

    @Autowired
    private JmxConfiguration configuration;

    @Bean
    public RmiRegistryFactoryBean rmiRegistryFactoryBean() {
        RmiRegistryFactoryBean factoryBean = new RmiRegistryFactoryBean();
        factoryBean.setPort(configuration.getPort());
        return factoryBean;
    }

    @Bean
    public ConnectorServerFactoryBean connectorServerFactoryBean() {
        ConnectorServerFactoryBean factoryBean = new ConnectorServerFactoryBean();
        String url = getUrl();
        factoryBean.setServiceUrl(url);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("JMX(rmi) connector server started: {}", url);
        }
        return factoryBean;
    }

    private String getUrl() {
        String host = configuration.getHost();
        int port = configuration.getPort();
        return "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/service";
    }
}
