package com.bxm.warcar.logging.autoconfigure;

import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.logging.support.LoggerLoggingWriter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.servlet.DispatcherType;

/**
 * @author allen
 * @since 2020-03-18
 */
@ConfigurationProperties(prefix = "warcar.logging")
public class LoggingProperties {

    /**
     * 是否开启日志功能
     */
    private boolean enable = false;
    /**
     * 拦截的URL表达式
     */
    private String urlPatterns = "/*";
    /**
     * 拦截器名称
     */
    private String filterName = "oncePerRequestLoggingFilter";
    /**
     * 拦截分发类型
     */
    private DispatcherType dispatcherType = DispatcherType.REQUEST;

    /**
     * 预处理数据最大长度，当请求体和响应内容超过这个长度将进行截取
     */
    private int payloadByteMaxLength = 1024;
    /**
     * 配置 LoggingWriter 实现类
     */
    private Class<? extends LoggingWriter> writer = LoggerLoggingWriter.class;

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getUrlPatterns() {
        return urlPatterns;
    }

    public void setUrlPatterns(String urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public DispatcherType getDispatcherType() {
        return dispatcherType;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public int getPayloadByteMaxLength() {
        return payloadByteMaxLength;
    }

    public void setPayloadByteMaxLength(int payloadByteMaxLength) {
        this.payloadByteMaxLength = payloadByteMaxLength;
    }

    public Class<? extends LoggingWriter> getWriter() {
        return writer;
    }

    public void setWriter(Class<? extends LoggingWriter> writer) {
        this.writer = writer;
    }
}
