/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging.autoconfigure;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.logging.autoconfigure.AliyunLogServiceProperties;
import com.bxm.warcar.logging.autoconfigure.LoggerLoggingWriterAutoConfigure;
import com.bxm.warcar.logging.support.AliyunLogServiceLoggingWriter;
import com.bxm.warcar.logging.support.LoggerLoggingWriter;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={LogProducer.class, ProducerConfig.class, ProjectConfig.class})
@EnableConfigurationProperties(value={AliyunLogServiceProperties.class})
@AutoConfigureAfter(value={LoggerLoggingWriterAutoConfigure.class})
public class AliyunLogServiceLoggingWriterAutoConfiguration {
    private final AliyunLogServiceProperties properties;

    public AliyunLogServiceLoggingWriterAutoConfiguration(AliyunLogServiceProperties properties) {
        this.properties = properties;
    }

    @Bean
    public AliyunLogServiceLoggingWriter aliyunLogServiceLoggingWriter(LoggerLoggingWriter fallback) {
        ProducerConfig producerConfig = new ProducerConfig();
        ProjectConfig projectConfig = new ProjectConfig(this.properties.getProject(), this.properties.getEndpoint(), this.properties.getAccessKeyId(), this.properties.getAccessKeySecret());
        String logStore = this.properties.getLogStore();
        AliyunLogServiceLoggingWriter writer = new AliyunLogServiceLoggingWriter(producerConfig, projectConfig, logStore);
        if (this.properties.isEnableThreadPool()) {
            int coreSize = this.properties.getCoreSize();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("sls-writer"));
            writer.setExecutor(executor);
        }
        writer.setFallback((LoggingWriter)fallback);
        return writer;
    }
}

