package com.bxm.warcar.voice.autoconfigure.submail;

import com.bxm.warcar.voice.submail.SubmailSmsVoiceSender;
import com.bxm.warcar.voice.submail.VoiceSender;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/02/12 14:15
 */
@Configuration
@EnableConfigurationProperties(SubmailVoiceProperties.class)
public class SubmailVoiceAutoConfiguration {

    private final SubmailVoiceProperties smsProperties;

    public SubmailVoiceAutoConfiguration(SubmailVoiceProperties smsProperties) {
        this.smsProperties = smsProperties;
    }

    @Bean
    public VoiceSender submailVoiceSender() {
        return new SubmailSmsVoiceSender(smsProperties.getAppid(),
                smsProperties.getAppkey(),
                smsProperties.getUrl(),
                smsProperties.getProject());
    }
}
