package com.bxm.warcar.message.autoconfigure.sms.submail;

import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.sms.submail.SubmailSmsMessageSender;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/07/30 21:15
 */
@ConditionalOnProperty(prefix = SubmailSmsProperties.PREFIX, value = "appid")
@EnableConfigurationProperties(SubmailSmsProperties.class)
public class SubmailSmsMessageAutoConfiguration {

    private final SubmailSmsProperties smsProperties;

    public SubmailSmsMessageAutoConfiguration(SubmailSmsProperties smsProperties) {
        this.smsProperties = smsProperties;
    }

    @Bean
    public MessageSender submailSmsMessageSender() {
        return new SubmailSmsMessageSender(smsProperties.getAppid(), smsProperties.getAppkey(), smsProperties.getUrl());
    }
}
