package com.bxm.warcar.message.autoconfigure.email;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = "warcar.message.email")
public class EmailProperties {

    private String host;
    private int port = 465;
    private String username;
    private String password;

    public String getHost() {
        return host;
    }

    public EmailProperties setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return port;
    }

    public EmailProperties setPort(int port) {
        this.port = port;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public EmailProperties setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public EmailProperties setPassword(String password) {
        this.password = password;
        return this;
    }
}
