package com.bxm.warcar.micrometer.autoconfigure.integration.dot;

import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.micrometer.integration.dot.AsyncDotMeter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author allen
 * @date 2019/8/29
 * @since 1.0.0
 */
@Configuration
@ConditionalOnBean(Dot.class)
public class DotMeterAutoConfiguration {

    @Bean
    public AsyncDotMeter dotMeter(ApplicationContext applicationContext) {
        Map<String, AsyncDot> beans = applicationContext.getBeansOfType(AsyncDot.class);
        return new AsyncDotMeter(beans);
    }
}
