package com.bxm.warcar.micrometer.autoconfigure.dpl;

import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.micrometer.dpl.PluginBusMeter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2020-10-29
 * @since 1.0
 */
@Configuration
@ConditionalOnClass(PluginBus.class)
public class PluginBusMeterAutoConfiguration {

    @Bean
    @ConditionalOnBean(PluginBus.class)
    public PluginBusMeter pluginBusMeter(ObjectProvider<PluginBus> provider) {
        return new PluginBusMeter(provider.getIfAvailable());
    }
}
