package com.bxm.warcar.mq.autoconfigure.alions;

import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.alions.AlionsProducer;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * @author allen
 * @date 2017-11-28
 */
@Configuration
@EnableConfigurationProperties({AlionsConfiguration.class, AlionsPropsConfiguration.class})
@ConditionalOnClass(com.aliyun.openservices.ons.api.Producer.class)
public class AlionsAutoConfiguration extends AbstractSubscriberHandler {

    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private AlionsPropsConfiguration propsConfiguration;

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer alionsProducer() {
        Properties config = propsConfiguration.getConfig();
        if (null != config) {
            return new AlionsProducer(config);
        }

        return new AlionsProducer(configuration.getProducerId(), configuration.getAccessKey(), configuration.getSecretKey());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        Properties config = propsConfiguration.getConfig();
        config.put(PropertyKeyConst.ConsumerId, consumerId);
        return new AlionsConsumer(config, messageListener);
    }
}
