package com.bxm.warcar.mq.autoconfigure.rocketmq;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.rocketmq.RocketmqConsumer;
import com.bxm.warcar.mq.rocketmq.RocketmqProducer;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(RocketmqProperties.class)
@ConditionalOnClass(DefaultMQProducer.class)
public class RocketmqAutoConfiguration extends AbstractSubscriberHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(RocketmqAutoConfiguration.class);

    private final RocketmqProperties properties;

    public RocketmqAutoConfiguration(RocketmqProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer rocketmqProducer(RocketmqProperties properties) {
        return new RocketmqProducer(properties.getNameSrvAddr(), properties.getProducerGroup());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        if (!(messageListener instanceof SingleMessageListener)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("RocketmqConsumer's message listener must instance of #SingleMessageListener!");
            }
            return null;
        }
        return new RocketmqConsumer(consumerId, (SingleMessageListener) messageListener);
    }
}
