package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.redis.RedisConsumer;
import com.bxm.warcar.mq.redis.RedisProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;

/**
 * @author allen
 * @date 2019/10/17
 * @since 1.0.0
 */
@Configuration
@ConditionalOnClass(RedisConnectionFactory.class)
public class RedisAutoConfiguration extends AbstractSubscriberHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(RedisAutoConfiguration.class);
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisAutoConfiguration(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    @Bean
    public RedisTemplate<String, Message> mqRedisTemplate() {
        RedisTemplate<String, Message> redisTemplate = new RedisTemplate<>();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(new Jackson2JsonRedisSerializer<>(String.class));
        redisTemplate.setValueSerializer(new Jackson2JsonRedisSerializer<>(Message.class));
        return redisTemplate;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer redisProducer() {
        return new RedisProducer(mqRedisTemplate());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        if (!(messageListener instanceof SingleMessageListener)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("RedisConsumer's message listener must instance of #SingleMessageListener!");
            }
            return null;
        }
        return new RedisConsumer(mqRedisTemplate(), (SingleMessageListener) messageListener);
    }
}
