/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractSubscriberHandler
implements DisposableBean,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSubscriberHandler.class);
    private final ConcurrentHashMap<String, Consumer> consumers = new ConcurrentHashMap();

    protected abstract Consumer create(String var1, Listener var2);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansWithAnnotation(Subscriber.class);
        if (MapUtils.isEmpty((Map)beans)) {
            return;
        }
        for (Map.Entry entry : beans.entrySet()) {
            Object object = entry.getValue();
            this.register(object);
        }
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, Consumer> entry : this.consumers.entrySet()) {
            String key = entry.getKey();
            Consumer consumer = entry.getValue();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Consumer {} on shutdown", (Object)key);
            }
            consumer.shutdown();
        }
    }

    private void register(Object object) {
        if (!(object instanceof Listener)) {
            return;
        }
        if (!(object instanceof SubscriberWrapper)) {
            return;
        }
        Subscriber subscriber = (Subscriber)AnnotationUtils.findAnnotation(object.getClass(), Subscriber.class);
        if (null == subscriber) {
            return;
        }
        SubscriberWrapper subscribe = (SubscriberWrapper)object;
        String consumerId = subscribe.getConsumerId();
        if (StringUtils.isBlank((String)consumerId)) {
            return;
        }
        Listener listener = (Listener)object;
        Consumer consumer = this.create(consumerId, listener);
        if (null == consumer) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering consumer: {} of topic: {}", (Object)consumerId, (Object)listener.getTopic());
        }
        consumer.start();
        this.consumers.put(consumerId, consumer);
    }

    public Map<String, Consumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }

    private String getProperty(Object object, String name) {
        try {
            Object value = PropertyUtils.getProperty((Object)object, (String)name);
            return null != value ? value.toString() : null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("getProperty: ", (Throwable)e);
            }
            return null;
        }
    }
}

