/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.rocketmq;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="warcar.rocketmq")
public class RocketmqProperties {
    private String nameSrvAddr;
    private String producerGroup = "producer";
    private List<String> brokerAddrAlias = Lists.newArrayList();

    public String getNameSrvAddr() {
        return this.nameSrvAddr;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public List<String> getBrokerAddrAlias() {
        return this.brokerAddrAlias;
    }

    public void setBrokerAddrAlias(List<String> brokerAddrAlias) {
        this.brokerAddrAlias = brokerAddrAlias;
    }

    public Map<String, String> getBrokerAddrAliasMap() {
        String split = "->";
        HashMap map = Maps.newHashMap();
        this.brokerAddrAlias.forEach(str -> {
            if (StringUtils.isBlank((String)str)) {
                return;
            }
            String[] strings = StringUtils.split((String)str, (String)split);
            if (strings.length > 1) {
                map.put(strings[0].trim(), strings[1].trim());
            }
        });
        return map;
    }
}

