package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.redis.JedisPublisher;
import com.bxm.warcar.mq.redis.JedisSubscriber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * <h3>广播模式</h3>
 * <p>
 *     发布消息 {@link JedisPublisher}
 *     订阅消息 {@link JedisSubscriber}
 *     注意此方法不支持事务,并且当消息订阅者消费速度慢,会出现问题 。
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2020/01/06 09:50
 */
@ConditionalOnClass({JedisPool.class, JedisConfiguration.class})
public class JedisBroadcastingAutoConfiguration {

    private final JedisPool jedisPool;

    @Autowired
    public JedisBroadcastingAutoConfiguration(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer jedisPublisher() {
        return new JedisPublisher(jedisPool);
    }
}
