package com.bxm.warcar.mq.autoconfigure.kafka;

import com.bxm.warcar.mq.Producer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @since 1.0.0
 */
@EnableConfigurationProperties(KafkaProperties.class)
@ConditionalOnClass(KafkaProducer.class)
public class KafkaAutoConfiguration {

    private final KafkaProperties properties;

    public KafkaAutoConfiguration(KafkaProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer kafkaProducer() {
        return new com.bxm.warcar.mq.kafka.KafkaProducer(properties.getKafka());
    }
}
