package com.bxm.warcar.mq.autoconfigure;

import org.springframework.context.annotation.Configuration;

import java.lang.annotation.*;

/**
 * 在消息监听实现中可声明为订阅者，这样将自动创建Consumer。必须要配合{@link SubscriberWrapper}接口使用，否则无法生效。
 * <pre>
 *  下面这个例子创建了一个消息监听者，并声明了订阅者，这样不需要手动创建Consumer实例。
    #Subscriber
    #EnableConfigurationProperties(TesterProperties.class)
    public class CachePushListener implements SingleMessageListener, SubscriberWrapper {

        private final TesterProperties properties;

        public CachePushListener(TesterProperties properties) {
            this.properties = properties;
        }

        public String getTopic() {
            return properties.getTopic();
        }

        public ConsumeStatus consume(Message message, Object context) {
            System.out.println(message);
            return ConsumeStatus.CONSUME_SUCCESS;
        }

        public String getConsumerId() {
            return "CID_USER";
        }
    }
 * </pre>
 * @author allen
 * @since 1.0.0
 * @see SubscriberWrapper
 * @see com.bxm.warcar.mq.Listener
 * @deprecated 从 2.3.6 之后弃用了
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Configuration
@Deprecated
public @interface Subscriber {
}
