package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.redis.JedisProducer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2019/10/21
 * @since 1.0.0
 */
@ConditionalOnClass({JedisPool.class, JedisConfiguration.class})
@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisAutoConfiguration {

    private final JedisConfiguration jedisConfiguration;

    public JedisAutoConfiguration(JedisConfiguration jedisConfiguration) {
        this.jedisConfiguration = jedisConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean(JedisPool.class)
    public JedisPool jedisPool() {
        return new JedisPool(jedisConfiguration, jedisConfiguration.getHost(), jedisConfiguration.getPort(),
                jedisConfiguration.getTimeout(), jedisConfiguration.getPassword(),
                jedisConfiguration.getDatabase());
    }

    @Primary
    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer jedisProducer(JedisPool jedisPool) {
        return new JedisProducer(jedisPool);
    }
}
