package com.bxm.warcar.boot.tester.eventbus;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author allen
 * @date 2019/4/26
 * @since 1.0.0
 */
@Aspect
@Component
public class EventListenerInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(EventListenerInterceptor.class);

    @Pointcut("this(com.bxm.warcar.integration.eventbus.EventListener)")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        LOGGER.info("execute {}", point.getTarget().getClass().getName());
        return point.proceed();
    }
}
