package com.bxm.warcar.boot.tester.distributedscheduling;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author allen
 * @since 1.0.0
 */
@Component
public class MyTimer implements Timer {

    private final MyProperties properties;

    public MyTimer(MyProperties properties) {
        this.properties = properties;
    }

    @Override
    @Scheduled(fixedDelay = 60000, initialDelay = 10000)
    public void execute() {
        System.out.println("Hello distributed scheduling! " + properties.getConsumerId());
    }
}
