/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.cache.local;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.web.cache.redis.RedisCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class LocalCache
extends RedisCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalCache.class);
    private final LoadingCache<String, Optional<String>> cache;

    public LocalCache(JedisPool jedisPool, int duration, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite((long)duration, timeUnit).expireAfterWrite((long)(duration * 2), timeUnit).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String key) throws Exception {
                String value = LocalCache.this.get0(key);
                return Optional.ofNullable(value);
            }
        });
        this.jedisPool = jedisPool;
        this.jedisFetcher = new JedisFetcher(jedisPool);
        this.jedisUpdater = new JedisUpdater(jedisPool);
        this.key = this.key;
    }

    @Override
    public void set(String key, String value) {
        super.set(key, value);
    }

    @Override
    public void delete(String key) {
        super.delete(key);
    }

    @Override
    public String get(String key) {
        try {
            Optional optional = (Optional)this.cache.get((Object)key);
            return optional.orElse(null);
        }
        catch (ExecutionException e) {
            LOGGER.error("get: ", (Throwable)e);
            return null;
        }
    }
}

