package com.bxm.warcar.web.interceptor;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * <h3></h3>
 * <p>
 *      1,使用时必需初始化   @Bean
						 public WebIpInterceptorAutoConfiguration webMvcInterceptor(){
						       return new WebIpInterceptorAutoConfiguration();
						 }
 *		2,如果想排除一些路径不拦截，请继承此类，重新复写addInterceptors(InterceptorRegistry registry)方法
 *	    3,拦截规则
 *	      @see IpInterceptor
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 13:59
 */
@ConditionalOnWebApplication
@EnableConfigurationProperties({WebProperties.class, JedisConfiguration.class})
public class WebIpInterceptorAutoConfiguration extends WebMvcConfigurerAdapter {

	private static final Logger LOGGER = LoggerFactory.getLogger(WebIpInterceptorAutoConfiguration.class);
	private final JedisConfiguration configuration;
	private final WebProperties webProperties;

	public WebIpInterceptorAutoConfiguration(JedisConfiguration configuration, WebProperties webProperties) {
		this.configuration = configuration;
		this.webProperties = webProperties;
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		List<String> exclusions = webProperties.getIp().getExclusions();
		if (CollectionUtils.isNotEmpty(exclusions)) {
			LOGGER.info("The ip interceptor exclusions: {}", exclusions);
		}
		registry.addInterceptor(ipInterceptor()).addPathPatterns("/**").excludePathPatterns(exclusions);
	}

	@Bean
	public IpInterceptor ipInterceptor(){
		JedisPool jedisPool = new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
		return new IpInterceptor(jedisPool, webProperties);
	}
}
