/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.interceptor;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import com.bxm.warcar.web.interceptor.IpInterceptor;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import redis.clients.jedis.JedisPool;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={WebProperties.class, JedisConfiguration.class})
public class WebIpInterceptorAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebIpInterceptorAutoConfiguration.class);
    private final JedisConfiguration configuration;
    private final WebProperties webProperties;

    public WebIpInterceptorAutoConfiguration(JedisConfiguration configuration, WebProperties webProperties) {
        this.configuration = configuration;
        this.webProperties = webProperties;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> exclusions = this.webProperties.getIp().getExclusions();
        if (CollectionUtils.isNotEmpty(exclusions)) {
            LOGGER.info("The ip interceptor exclusions: {}", exclusions);
        }
        registry.addInterceptor((HandlerInterceptor)this.ipInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(exclusions);
    }

    @Bean
    public IpInterceptor ipInterceptor() {
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
        return new IpInterceptor(jedisPool, this.webProperties);
    }
}

