/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.mapping;

import com.bxm.warcar.web.mapping.LocalCache;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
@Aspect
public class MappingAroundAspect {
    private static final Logger logger = LoggerFactory.getLogger(MappingAroundAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) ")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object doAround(ProceedingJoinPoint point) throws Throwable {
        Object object;
        long startTime = System.currentTimeMillis();
        String clazz = point.getTarget().getClass().getName();
        Method method = this.getMethod((JoinPoint)point);
        String pathName = this.getPathMame(method);
        try {
            object = point.proceed();
        }
        catch (Throwable throwable) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pathName})) {
                LocalCache.INSTANCE.incr(pathName);
            }
            if (System.currentTimeMillis() - startTime > 1000L) {
                logger.info("Excute { {} } time > 1 S ", (Object)method);
            }
            throw throwable;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pathName})) {
            LocalCache.INSTANCE.incr(pathName);
        }
        if (System.currentTimeMillis() - startTime > 1000L) {
            logger.info("Excute { {} } time > 1 S ", (Object)method);
        }
        return object;
    }

    private String getPathMame(Method method) {
        RequestMapping requestmapping = method.getDeclaredAnnotation(RequestMapping.class);
        if (requestmapping != null) {
            return this.getPathName(requestmapping.path(), requestmapping.value());
        }
        PutMapping putMapping = method.getDeclaredAnnotation(PutMapping.class);
        if (putMapping != null) {
            return this.getPathName(putMapping.path(), putMapping.value());
        }
        PostMapping postMapping = method.getDeclaredAnnotation(PostMapping.class);
        if (postMapping != null) {
            return this.getPathName(postMapping.path(), postMapping.value());
        }
        DeleteMapping deleteMapping = method.getDeclaredAnnotation(DeleteMapping.class);
        if (deleteMapping != null) {
            return this.getPathName(deleteMapping.path(), deleteMapping.value());
        }
        GetMapping getMapping = method.getDeclaredAnnotation(GetMapping.class);
        if (getMapping != null) {
            return this.getPathName(getMapping.path(), getMapping.value());
        }
        PatchMapping patchMapping = method.getDeclaredAnnotation(PatchMapping.class);
        if (patchMapping != null) {
            return this.getPathName(patchMapping.path(), patchMapping.value());
        }
        return null;
    }

    private String getPathName(String[] paths, String[] values) {
        if (ArrayUtils.isNotEmpty((Object[])paths)) {
            return paths[0];
        }
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

