package com.bxm.warcar.web.cache.local;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.web.cache.redis.RedisCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * <h3></h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 10:18
 */
public class LocalCache extends RedisCache {

	private static final Logger LOGGER = LoggerFactory.getLogger(LocalCache.class);
	private final LoadingCache<String, Optional<String>> cache;

	/**
	 * @param duration 刷新间隔时间
	 * @param timeUnit 刷新间隔时间单位
	 */
	public LocalCache(JedisPool jedisPool, int duration, TimeUnit timeUnit) {
		this.cache = CacheBuilder.newBuilder()
				.refreshAfterWrite(duration, timeUnit)
				.expireAfterWrite(duration*2, timeUnit)
				.build(new CacheLoader<String, Optional<String>>() {
					@Override
					public Optional<String> load(String key) throws Exception {
						String value = get0(key);
						return Optional.ofNullable(value);
					}
				});

		this.jedisPool = jedisPool;
		this.jedisFetcher = new JedisFetcher(jedisPool);
		this.jedisUpdater = new JedisUpdater(jedisPool);
		this.key = key;
	}

	@Override
	public void set(String key, String value) {
		super.set(key, value);
	}

	@Override
	public void delete(String key) {
		super.delete(key);
	}

	@Override
	public String get(String key) {
		try {
			Optional<String> optional = this.cache.get(key);
			return optional.orElse(null);
		} catch (ExecutionException e) {
			LOGGER.error("get: ", e);
		}
		return null;
	}

}
