/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import com.bxm.warcar.web.cache.local.LocalCache;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import redis.clients.jedis.JedisPool;

public class IpInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
    private static final String ALL = "*";
    private static final int DURATION_TIME = 30;
    private static final String RESPONSE_MODEL = "{\"data\":null,\"success\":true,\"error\":false,\"code\":1,\"message\":\"ip\"}";
    private final LocalCache localCache;
    private final WebProperties webProperties;

    public IpInterceptor(JedisPool jedisPool) {
        this(jedisPool, new WebProperties());
    }

    public IpInterceptor(JedisPool jedisPool, WebProperties webProperties) {
        this.localCache = new LocalCache(jedisPool, 30, TimeUnit.MINUTES);
        this.webProperties = webProperties;
    }

    private boolean ignore(HttpServletRequest request) {
        WebProperties.Ip ip = this.webProperties.getIp();
        if (null == ip) {
            return false;
        }
        Map<String, Set<String>> ignoreParameters = ip.getIgnoreParameters();
        if (MapUtils.isNotEmpty(ignoreParameters)) {
            for (Map.Entry<String, Set<String>> entry : ignoreParameters.entrySet()) {
                String key = entry.getKey();
                String pvalue = request.getParameter(key);
                if (!entry.getValue().contains(pvalue)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (this.ignore(request)) {
                return true;
            }
            String ip = IpHelper.getIpFromHeader((HttpServletRequest)request);
            if (StringUtils.isBlank((String)ip)) {
                return true;
            }
            String ipkey = IpHelper.getIpNoDotTwo((String)ip);
            String ipvalue = this.localCache.get(ipkey);
            if (StringUtils.isBlank((String)ipvalue)) {
                return true;
            }
            if (ALL.equals(ipvalue)) {
                this.write(response);
                return false;
            }
            List list = JSONObject.parseArray((String)ipvalue, String.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return true;
            }
            if (list.contains(ip)) {
                this.write(response);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error(" Resolving IP exceptions !", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            response.setStatus(200);
            writer.print(RESPONSE_MODEL);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error(" Resolving IP write !", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

