package com.bxm.warcar.web.interceptor;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import com.bxm.warcar.web.autoconfigure.sentinel.JedisSentinelAutoConfiguration;
import com.bxm.warcar.web.autoconfigure.sentinel.JedisSentinelConfiguration;
import com.bxm.warcar.web.autoconfigure.vision.JedisVisionAutoConfiguration;
import com.bxm.warcar.web.autoconfigure.vision.JedisVisionConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * <h3></h3>
 * <p>
 *      1,使用时必需初始化   @Bean
						 public WebIpInterceptorAutoConfiguration webMvcInterceptor(){
						       return new WebIpInterceptorAutoConfiguration();
						 }
 *		2,如果想排除一些路径不拦截，请继承此类，重新复写addInterceptors(InterceptorRegistry registry)方法
 *	    3,拦截规则
 *	      @see IpInterceptor
 * </p>
 * <p>
 *     业务处理逻辑不应该放到基础框架里面来，该逻辑已经迁走，此处代码作废
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 13:59
 */
@Deprecated
@ConditionalOnWebApplication
@ConditionalOnBean(value = {JedisFetcher.class})
@EnableConfigurationProperties(WebProperties.class)
public class WebIpInterceptorAutoConfiguration extends WebMvcConfigurerAdapter {

	private static final Logger LOGGER = LoggerFactory.getLogger(WebIpInterceptorAutoConfiguration.class);

	private final JedisFetcher sentinelJedisFetcher;

	private final JedisFetcher visionJedisFetcher;

	private final WebProperties webProperties;

	@Autowired
	public WebIpInterceptorAutoConfiguration(WebProperties webProperties,
											 @Qualifier("sentinelJedisFetcher")JedisFetcher sentinelJedisFetcher,
											 @Qualifier("visionJedisFetcher")JedisFetcher visionJedisFetcher) {
		this.webProperties = webProperties;
		this.visionJedisFetcher = visionJedisFetcher;
		this.sentinelJedisFetcher = sentinelJedisFetcher;
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		List<String> exclusions = webProperties.getIp().getExclusions();
		if (CollectionUtils.isNotEmpty(exclusions)) {
			LOGGER.info("The ip interceptor exclusions: {}", exclusions);
		}
		registry.addInterceptor(ipInterceptor()).addPathPatterns("/**").excludePathPatterns(exclusions);
	}

	@Bean
	public IpInterceptor ipInterceptor(){
		LOGGER.info("IpInterceptor init...");
		return new IpInterceptor(sentinelJedisFetcher, visionJedisFetcher, webProperties);
	}
}
