/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.container.autoconfigure.task;

import com.bxm.warcar.container.task.RemoteExecutor;
import com.bxm.warcar.container.task.Shutdown;
import com.bxm.warcar.container.task.TaskMetrics;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ConditionalOnProperty(prefix="warcar.container", name={"enabled"}, havingValue="true")
public class TaskAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAutoConfiguration.class);
    private RemoteExecutor remoteExecutor;

    @Bean
    public TaskMetrics taskMetrics() {
        return new TaskMetrics();
    }

    @Bean
    public RemoteExecutor remoteExecutor() {
        this.remoteExecutor = new RemoteExecutor(this.taskMetrics());
        return this.remoteExecutor;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (context.getParent() == null) {
            Map beansOfType = context.getBeansOfType(Shutdown.class);
            Set entries = beansOfType.entrySet();
            for (Map.Entry entry : entries) {
                Shutdown bean = (Shutdown)entry.getValue();
                this.remoteExecutor.add(bean);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Registering shutdown bean {}", (Object)bean);
            }
        }
    }
}

