/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.user.service.facade;

import com.bxm.user.facade.service.UserMappingService;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@RestController
public class UserMappingServiceImpl
implements UserMappingService {
    private static final int EXPIRE = TypeHelper.castToInt((Object)Duration.ofDays(7L).getSeconds());
    private final int ASSET_DB = 8;
    private final Updater updater;
    private final Fetcher fetcher;
    private final IdGenerator id;

    public UserMappingServiceImpl(Updater updater, Fetcher fetcher, IdGenerator id) {
        this.updater = updater;
        this.fetcher = fetcher;
        this.id = id;
    }

    public void set(String appId, String uid, String cuid) {
        if (StringUtils.isNotBlank((String)cuid)) {
            this.updater.update(UserMappingServiceImpl.stringMappingForUid(appId, uid), (Object)cuid, EXPIRE);
        }
        if (StringUtils.isNotBlank((String)uid)) {
            this.updater.update(UserMappingServiceImpl.stringMappingForCuid(appId, cuid), (Object)uid, EXPIRE);
        }
    }

    public void setInherit(String appId, String uid, String cuid, String pcuid) {
        this.set(appId, uid, cuid);
        KeyGenerator key = UserMappingServiceImpl.assetMappingForCuid(appId, cuid);
        String assetId = (String)this.fetcher.fetch(new TargetFactory().keyGenerator(key).cls(String.class).skipNativeCache(true).selector(8).build());
        if (null != assetId) {
            return;
        }
        boolean isInherit = false;
        if (StringUtils.isNotBlank((String)pcuid)) {
            KeyGenerator keyPcuid = UserMappingServiceImpl.assetMappingForCuid(appId, pcuid);
            assetId = (String)this.fetcher.fetch(new TargetFactory().keyGenerator(keyPcuid).cls(String.class).skipNativeCache(true).selector(8).build());
            if (null != assetId) {
                isInherit = true;
                this.updater.updateWithSelector(key, (Object)assetId, 8);
                this.updater.removeWithSelector(keyPcuid, 8);
            } else {
                assetId = this.id.next();
                this.updater.updateWithSelector(key, (Object)assetId, 8);
            }
        } else {
            assetId = this.id.next();
            this.updater.updateWithSelector(key, (Object)assetId, 8);
        }
        KeyGenerator keyAsset = UserMappingServiceImpl.assetMappingForId(appId, assetId);
        this.updater.zupdateWithSelector(keyAsset, Double.valueOf(System.currentTimeMillis()), (Object)cuid, 8);
        if (isInherit) {
            this.updater.zremoveWithSelector(keyAsset, 8, new String[]{pcuid});
        }
    }

    public String getByUid(String appId, String uid, Boolean skipCache) {
        return (String)this.fetcher.fetch(new TargetFactory().keyGenerator(UserMappingServiceImpl.stringMappingForUid(appId, uid)).cls(String.class).skipNativeCache(Boolean.TRUE.equals(skipCache)).build());
    }

    public Map<String, String> getMappingByUid(String appId, String[] uids) {
        Object original = this.updater.getClientOriginal();
        if (original instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)original;
            try (Jedis jedis = jedisPool.getResource();){
                Pipeline pipelined = jedis.pipelined();
                HashMap<String, Response> mp = new HashMap<String, Response>(uids.length);
                for (String uid : uids) {
                    String key = UserMappingServiceImpl.stringMappingForUid(appId, uid).generateKey();
                    Response response = pipelined.get(key);
                    mp.put(uid, response);
                }
                pipelined.sync();
                HashMap res = new HashMap(uids.length);
                for (Map.Entry entry : mp.entrySet()) {
                    String value = (String)((Response)entry.getValue()).get();
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    res.put(entry.getKey(), value);
                }
                HashMap hashMap = res;
                return hashMap;
            }
        }
        return null;
    }

    public String getByCuid(String appId, String cuid, Boolean skipCache) {
        return (String)this.fetcher.fetch(new TargetFactory().keyGenerator(UserMappingServiceImpl.stringMappingForCuid(appId, cuid)).cls(String.class).skipNativeCache(Boolean.TRUE.equals(skipCache)).build());
    }

    public String getAssetByCuid(String appId, String cuid, Boolean skipCache) {
        return (String)this.fetcher.fetch(new TargetFactory().keyGenerator(UserMappingServiceImpl.assetMappingForCuid(appId, cuid)).cls(String.class).skipNativeCache(Boolean.TRUE.equals(skipCache)).selector(8).build());
    }

    public Map<String, String> getAssetLastByIds(String appId, String[] ids) {
        HashMap<String, String> res = new HashMap<String, String>();
        Object original = this.updater.getClientOriginal();
        if (original instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)original;
            try (Jedis jedis = jedisPool.getResource();){
                HashMap<String, Response> mp = new HashMap<String, Response>(ids.length);
                jedis.select(8);
                Pipeline pipelined = jedis.pipelined();
                for (String id : ids) {
                    String key = UserMappingServiceImpl.assetMappingForId(appId, id).generateKey();
                    Response response = pipelined.zrange(key, 0L, -1L);
                    mp.put(id, response);
                }
                pipelined.syncAndReturnAll();
                for (Map.Entry entry : mp.entrySet()) {
                    String id = (String)entry.getKey();
                    LinkedHashSet value = (LinkedHashSet)((Response)entry.getValue()).get();
                    if (CollectionUtils.isEmpty((Collection)value)) continue;
                    if (1 == value.size()) {
                        res.put(id, (String)value.iterator().next());
                        continue;
                    }
                    Iterator it = value.iterator();
                    String s = null;
                    while (it.hasNext()) {
                        s = (String)it.next();
                    }
                    if (null == s) continue;
                    res.put(id, s);
                }
                HashMap<String, String> hashMap = res;
                return hashMap;
            }
        }
        return res;
    }

    private static KeyGenerator stringMappingForUid(String appId, String uid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"user", "mapping", "uid", appId, uid});
    }

    private static KeyGenerator stringMappingForCuid(String appId, String cuid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"user", "mapping", "cuid", appId, cuid});
    }

    private static KeyGenerator assetMappingForCuid(String appId, String cuid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"user", "mapping", "asset", "cuid", appId, cuid});
    }

    private static KeyGenerator assetMappingForId(String appId, String assetId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"user", "mapping", "asset", "id", appId, assetId});
    }
}

