package com.bxm.vision.data.facade;

import com.bxm.vision.data.facade.model.DataDto;
import com.bxm.vision.data.facade.model.MongoDim2AdsDto;
import com.bxm.vision.data.facade.model.SqlDto;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.Map;

/**
 * 数据服务
 *
 * @ClassName DataFeignClientService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/12/28 16:57
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/12/28 16:57
 **/
@FeignClient("data-service")
public interface DataFeignClientService {
    /**
     * 阿里云分析型数据库查询，统一返回 List<Map<String, Object>> 易扩展
     *
     * @param dataDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<java.util.Map<java.lang.String,java.lang.Object>>>
     * @throws
     * @author kk.xie
     * @date 2018/12/29 11:03
     */
    @RequestMapping(value = "/data/executeAds", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeAds(@RequestBody DataDto dataDto);

    @RequestMapping(value = "/data/executeDoris", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeDoris(@RequestBody DataDto dataDto);

    /**
     * Elasticsearch数据库查询，统一返回 List<Map<String, Object>> 易扩展
     *
     * @param dataDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<java.util.Map<java.lang.String,java.lang.Object>>>
     * @throws
     * @author kk.xie
     * @date 2018/12/29 11:03
     */
    @RequestMapping(value = "/data/executeElasticsearch", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeElasticsearch(@RequestBody DataDto dataDto);

    /**
     * Hadoop数据库查询，统一返回 List<Map<String, Object>> 易扩展
     *
     * @param dataDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<java.util.Map<java.lang.String,java.lang.Object>>>
     * @throws
     * @author kk.xie
     * @date 2018/12/29 11:03
     */
    @RequestMapping(value = "/data/executeHadoop", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeHadoop(@RequestBody DataDto dataDto);

    /**
     * MongoDb数据库查询，统一返回 List<Map<String, Object>> 易扩展
     *
     * @param dataDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<java.util.Map<java.lang.String,java.lang.Object>>>
     * @throws
     * @author kk.xie
     * @date 2018/12/29 11:03
     */
    @RequestMapping(value = "/data/executeMongo", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeMongo(@RequestBody DataDto dataDto);

    /**
     * Mysql数据库查询，统一返回 List<Map<String, Object>> 易扩展
     *
     * @param dataDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<java.util.Map<java.lang.String,java.lang.Object>>>
     * @throws
     * @author kk.xie
     * @date 2018/12/29 11:03
     */
    @RequestMapping(value = "/data/executeMysql", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> executeMysql(@RequestBody DataDto dataDto);

    /**
     * mongo中识别的维度数据写入到ads中
     *
     * @param mongoDim2AdsDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/30 14:58
     */
    @RequestMapping(value = "/data/insertMongoDimData2Ads", method = RequestMethod.POST)
    ResponseModel<Boolean> insertMongoDimData2Ads(@RequestBody MongoDim2AdsDto mongoDim2AdsDto);

    /**
     * select count
     *
     * @param countDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Long>
     * @author kk.xie
     * @date 2020/1/6 19:30
     */
    @RequestMapping(value = "/data/selectCount", method = RequestMethod.POST)
    ResponseModel<Long> selectCount(@RequestBody SqlDto countDto);

    /**
     * select map
     *
     * @param countDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Long>
     * @author kk.xie
     * @date 2020/1/6 19:49
     */
    @RequestMapping(value = "/data/selectMap", method = RequestMethod.POST)
    ResponseModel<Map<String,Object>> selectMap(@RequestBody SqlDto countDto);

    /**
     * select list
     *
     * @param countDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Long>
     * @author kk.xie
     * @date 2020/1/6 19:49
     */
    @RequestMapping(value = "/data/selectList", method = RequestMethod.POST)
    ResponseModel<List<Map<String,Object>>> selectList(@RequestBody SqlDto countDto);
}
