package com.bxm.vision.data.sdk.autoconfigure.dot;

import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.impl.DefaultDotImpl;
import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/5/12 17:31
 */
@Configuration
@EnableConfigurationProperties(VisionDotProperties.class)
public class VisionDotAutoConfiguration {

    private final VisionDotProperties properties;

    public VisionDotAutoConfiguration(VisionDotProperties properties) {
        this.properties = properties;
    }

    @Bean
    public AsyncDot visionAsyncDot() {
        VisionDotProperties.ThreadPoolProperties threadPool = properties.getThreadPool();
        return new ThreadPoolExecutorDotImpl(new DefaultDotImpl(properties.getUrl()), threadPool.getPoolCoreSize(), threadPool.getAwaitTerminationTimeInSeconds());
    }

    @Bean
    public DotSupport dotSupport(){
        return new DotSupport(visionAsyncDot());
    }
}
