package com.bxm.vision.data.sdk.autoconfigure;

import com.bxm.warcar.integration.dc.dot.*;
import com.bxm.warcar.utils.IpHelper;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/5/13 09:15
 */
public class DotSupport {

    private static final Logger LOGGER = LoggerFactory.getLogger(DotSupport.class);

    private final AsyncDot asyncDot;

    public DotSupport(AsyncDot asyncDot) {
        this.asyncDot = asyncDot;
    }

    public void asyncDoGet(HttpServletRequest request, Map<String, String> map) {
        String modeltype = request.getParameter("modeltype");
        if (StringUtils.isBlank(modeltype)){
            return;
        }
        ModelTypeEnum modelTypeEnum = of(modeltype);
        if (null == modelTypeEnum) {
            return;
        }
        String business = request.getParameter("business");
        if (StringUtils.isNotBlank(business)) {
            business = business.replaceAll("ad-|money-", "money-");
        }

        DotParameterFactory factory = DotParameterFactory.create(VerEnum.V2)
                .ip(IpHelper.getIpFromHeader(request))
                .userAgent(request.getHeader("user-agent"))
                .referrer(request.getHeader("referer"))
                .bxmid(request.getParameter("countId"))
                .price(NumberUtils.toLong(request.getParameter("offerPrice")))
                .mt(modelTypeEnum)
                .popupId(request.getParameter("popupId"))
                .awardId(request.getParameter("preid"))
                .assetsId(request.getParameter("assetsId"))
                .scene(String.valueOf(request.getParameter("scene")))
                .ts(System.currentTimeMillis())
                .appkey(request.getParameter("appkey"))
                .business(business)
                .activityId(request.getParameter("activityid"))
                .uid(request.getParameter("uid"))
                .spm(request.getParameter("spm"))
                .imei(request.getParameter("i"))
                .idfa(request.getParameter("f"))
                .ext(request.getParameter("ext"))
                .toType(parseDomain(request.getHeader("Origin")));

        String random3 = request.getParameter("random3");
        if (StringUtils.isNotBlank(random3) && random3.split(",").length == 2) {
            factory.sw(NumberUtils.toInt(random3.split(",")[0]));
            factory.sh(NumberUtils.toInt(random3.split(",")[1]));
        }
        DotParameter dotParameter = factory.build();
        dotParameter.put("fmModelId", request.getParameter("fmModelId"));
        dotParameter.put("banned", map.get("banned"));
        dotParameter.put("did", request.getParameter("did"));
        asyncDot.asyncDoGet(dotParameter);
    }

    public void asyncDoGetEffect(DotParameter parameter) {
        //大数据埋点统计
        asyncDot.asyncDoGet(parameter);
    }

    private static ModelTypeEnum of(String modeltype) {
        try {
            for (ModelTypeEnum modelTypeEnum : ModelTypeEnum.values()) {
                if (Integer.parseInt(modeltype) == modelTypeEnum.getOriginal()) {
                    return modelTypeEnum;
                }
            }
        } catch (IllegalArgumentException e) {
            LOGGER.warn("Unknown model type of: {}", modeltype);
            return null;
        }
        return null;
    }

    private String parseDomain(String origin) {
        if (StringUtils.isBlank(origin)) {
            return null;
        }
        try {
            return new URL(origin).getHost();
        } catch (MalformedURLException e) {
            return null;
        }
    }

}
