package com.bxm.vision.data.sdk.autoconfigure.dot;

import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/5/12 17:31
 */
@ConfigurationProperties(prefix = "vision.sdk.dc.dot")
public class VisionDotProperties {

    private String url = "http://61.130.182.195:2080/dot/s.gif";
    private ThreadPoolProperties threadPool = new ThreadPoolProperties();

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ThreadPoolProperties getThreadPool() {
        return threadPool;
    }

    public void setThreadPool(ThreadPoolProperties threadPool) {
        this.threadPool = threadPool;
    }

    public static class ThreadPoolProperties {

        private int poolCoreSize = ThreadPoolExecutorDotImpl.DEFAULT_POOL_CORE_SIZE;
        private int awaitTerminationTimeInSeconds = ThreadPoolExecutorDotImpl.DEFAULT_AWAIT_TERMINATION_TIME_IN_SECONDS;

        public int getPoolCoreSize() {
            return poolCoreSize;
        }

        public void setPoolCoreSize(int poolCoreSize) {
            this.poolCoreSize = poolCoreSize;
        }

        public int getAwaitTerminationTimeInSeconds() {
            return awaitTerminationTimeInSeconds;
        }

        public void setAwaitTerminationTimeInSeconds(int awaitTerminationTimeInSeconds) {
            this.awaitTerminationTimeInSeconds = awaitTerminationTimeInSeconds;
        }
    }
}
