package com.bxm.vision.data.sdk.autoconfigure.jedis;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/5/12 14:15
 */
@Configuration
@EnableConfigurationProperties({JedisVisionConfiguration.class, JedisSentinelConfiguration.class, JedisOldConfiguration.class})
public class JedisAutoConfiguration {

    @Autowired
    private JedisSentinelConfiguration sentinelConfiguration;

    @Autowired
    private JedisVisionConfiguration visionConfiguration;
    @Autowired
    private JedisOldConfiguration oldConfiguration;

    @Bean
    public JedisPool sentinelJedisPool() {
        return new JedisPool(sentinelConfiguration, sentinelConfiguration.getHost(), sentinelConfiguration.getPort(), sentinelConfiguration.getTimeout(), sentinelConfiguration.getPassword(), sentinelConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher sentinelJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(sentinelJedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisPool visionJedisPool() {
        return new JedisPool(visionConfiguration, visionConfiguration.getHost(), visionConfiguration.getPort(), visionConfiguration.getTimeout(), visionConfiguration.getPassword(), visionConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher visionJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(visionJedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisPool oldJedisPool() {
        return new JedisPool(oldConfiguration, oldConfiguration.getHost(), oldConfiguration.getPort(), oldConfiguration.getTimeout(), oldConfiguration.getPassword(), oldConfiguration.getDatabase());
    }

    @Bean
    public JedisUpdater oldJedisUpdater() {
        JedisUpdater jedisUpdater = new JedisUpdater(oldJedisPool());
        return jedisUpdater;
    }

    @Bean
    public JedisFetcher oldJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(oldJedisPool());
        return jedisFetcher;
    }
}
