package com.bxm.vision.data.sdk.interceptor;

import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.vision.data.sdk.WebProperties;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * <h3></h3>
 * <p>
 *      1,使用时必需初始化   @Bean
						 public WebIpInterceptorAutoConfiguration webMvcInterceptor(){
						       return new WebIpInterceptorAutoConfiguration();
						 }
 *		2,如果想排除一些路径不拦截，请继承此类，重新复写addInterceptors(InterceptorRegistry registry)方法
 *	    3,拦截规则
 *	      @see IpInterceptor
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 13:59
 */
@ConditionalOnWebApplication
@ConditionalOnBean(value = {JedisFetcher.class})
@EnableConfigurationProperties(WebProperties.class)
public class WebIpInterceptorAutoConfiguration implements WebMvcConfigurer {

	private static final Logger LOGGER = LoggerFactory.getLogger(WebIpInterceptorAutoConfiguration.class);

	private final JedisFetcher sentinelJedisFetcher;

	private final JedisFetcher visionJedisFetcher;

	private final WebProperties webProperties;

	private final DotSupport dotSupport;

	private final JedisUpdater jedisUpdater;

	private final JedisFetcher jedisFetcher;

	@Autowired
	public WebIpInterceptorAutoConfiguration(WebProperties webProperties,
											 @Qualifier("sentinelJedisFetcher")JedisFetcher sentinelJedisFetcher,
											 @Qualifier("visionJedisFetcher")JedisFetcher visionJedisFetcher,
											 DotSupport dotSupport,
											 @Qualifier("oldJedisUpdater") JedisUpdater jedisUpdater,
											 @Qualifier("oldJedisFetcher") JedisFetcher jedisFetcher) {
		this.webProperties = webProperties;
		this.visionJedisFetcher = visionJedisFetcher;
		this.sentinelJedisFetcher = sentinelJedisFetcher;
		this.dotSupport = dotSupport;
		this.jedisUpdater = jedisUpdater;
		this.jedisFetcher = jedisFetcher;
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		List<String> exclusions = webProperties.getIp().getExclusions();
		if (CollectionUtils.isNotEmpty(exclusions)) {
			LOGGER.info("The ip com.bxm.vision.data.sdk.interceptor exclusions: {}", exclusions);
		}
		registry.addInterceptor(ipInterceptor()).addPathPatterns("/**").excludePathPatterns(exclusions);
	}

	@Bean
	public IpInterceptor ipInterceptor(){
		return new IpInterceptor(sentinelJedisFetcher, visionJedisFetcher, webProperties, dotSupport,jedisUpdater,jedisFetcher);
	}
}
