package com.bxm.vision.engine.facade;

import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 报表任务对外服务
 *
 * @Author kk.xie
 * @Date 2019/4/23 17:14
 * @Version 1.0
 **/
@FeignClient("engine-schedule")
public interface ReportJobFeignClientService {
    /**
     * 报表任务重启
     *
     * @param taskId
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2019/4/23 17:17
     */
    @RequestMapping(value = "/report/job/restart", method = RequestMethod.POST)
    ResponseModel<Boolean> restartTask(@RequestParam String taskId);

    /**
     * 报表任务启动
     *
     * @param taskId
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2019/4/23 17:18
     */
    @RequestMapping(value = "/report/job/start", method = RequestMethod.POST)
    ResponseModel<Boolean> startTask(@RequestParam String taskId);

    /**
     * 报表任务关闭
     *
     * @param taskId
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2019/4/23 17:18
     */
    @RequestMapping(value = "/report/job/stop", method = RequestMethod.POST)
    ResponseModel<Boolean> stopTask(@RequestParam String taskId);
}
