package com.bxm.vision.punish.facade.model;


import java.io.Serializable;

/**
 * <p>
 * 封禁日志表
 * </p>
 *
 * @author kk.xie
 * @since 2019-10-29
 */
public class BannedLogDto implements Serializable {

    private static final long serialVersionUID = -7893473150062439482L;
    /**
     * uuid
     */
    private String uuid;
    /**
     * 规则编码
     */
    private String rulerCode;
    /**
     * 封禁内容,IP或UID
     */
    private String bannedContent;
    /**
     * 封禁类型 1-IP，2-UID
     */
    private Integer bannedType;
    /**
     * 封禁状态 0-否 1-是
     */
    private Integer bannedStatus;
    /**
     * 来源，环视系统， 广告系统，境外IP自动封禁
     */
    private String bannedSource;
    /**
     * 媒体名称
     */
    private String appAlias;
    /**
     * 渠道号
     */
    private String business;
    /**
     * 媒介
     */
    private String mj;
    /**
     * 备注
     */
    private String remark;


    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getRulerCode() {
        return rulerCode;
    }

    public void setRulerCode(String rulerCode) {
        this.rulerCode = rulerCode;
    }

    public String getBannedContent() {
        return bannedContent;
    }

    public void setBannedContent(String bannedContent) {
        this.bannedContent = bannedContent;
    }

    public Integer getBannedType() {
        return bannedType;
    }

    public void setBannedType(Integer bannedType) {
        this.bannedType = bannedType;
    }

    public Integer getBannedStatus() {
        return bannedStatus;
    }

    public void setBannedStatus(Integer bannedStatus) {
        this.bannedStatus = bannedStatus;
    }

    public String getBannedSource() {
        return bannedSource;
    }

    public void setBannedSource(String bannedSource) {
        this.bannedSource = bannedSource;
    }

    public String getAppAlias() {
        return appAlias;
    }

    public void setAppAlias(String appAlias) {
        this.appAlias = appAlias;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getMj() {
        return mj;
    }

    public void setMj(String mj) {
        this.mj = mj;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "BannedLogDto{" +
                "uuid='" + uuid + '\'' +
                ", rulerCode='" + rulerCode + '\'' +
                ", bannedContent='" + bannedContent + '\'' +
                ", bannedType=" + bannedType +
                ", bannedStatus=" + bannedStatus +
                ", bannedSource='" + bannedSource + '\'' +
                ", appAlias='" + appAlias + '\'' +
                ", business='" + business + '\'' +
                ", mj='" + mj + '\'' +
                ", remark='" + remark + '\'' +
                '}';
    }
}
