package com.bxm.warcar.algorithm;

import java.io.Serializable;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/15 20:01
 */
public class NumericalModel implements Serializable {

	private static final long serialVersionUID = 6177017328728350916L;

	/**
	 * 计算模型唯一标识，如素材id
	 */
	private String id;

	/**
	 * 分组标识，如广告位
	 */
	private String groupId;


	/**
	 * 2h点击率
	 */
	private Long openPv2H =  0L;

	/**
	 * 24h点击率
	 */
	private Long openPv24H =  0L;


	/**
	 * 2h点击率
	 */
	private double clickRate2H = 0.0;

	/**
	 * 24h点击率
	 */
	private double clickRate24H = 0.0;

	/**
	 * 曝光PV
	 */
	private Long openPv = 0L;

	/**
	 * 点击率
	 */
	private double clickRate = 0.0;

	/**
	 * 流量比率
	 */
	private double flowRate = 0;

	/**
	 * 分组前日PV
	 */
	private Long preGroupDatePv = 0L;

	/**
	 * 分组点击率
	 */
	private double groupClickRate=0.0;


	public NumericalModel(){}

	public NumericalModel(String id, String groupId, Long openPv, Long preGroupDatePv, Double groupClickRate, Double clickRate) {
		this.id = id;
		this.groupId = groupId;
		if (null!=openPv){
			this.openPv = openPv;
		}
		if (null!=preGroupDatePv){
			this.preGroupDatePv = preGroupDatePv;
		}
		if (null!=groupClickRate){
			this.groupClickRate = groupClickRate;
		}
		if (null!=clickRate){
			this.clickRate = clickRate;
		}
	}

	public double getClickRate2H() {
		return clickRate2H;
	}

	public void setClickRate2H(double clickRate2H) {
		this.clickRate2H = clickRate2H;
	}

	public double getClickRate24H() {
		return clickRate24H;
	}

	public void setClickRate24H(double clickRate24H) {
		this.clickRate24H = clickRate24H;
	}

	public double getGroupClickRate() {
		return groupClickRate;
	}

	public void setGroupClickRate(double groupClickRate) {
		this.groupClickRate = groupClickRate;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public double getClickRate() {
		return clickRate;
	}

	public void setClickRate(double clickRate) {
		this.clickRate = clickRate;
	}

	public Long getPreGroupDatePv() {
		return preGroupDatePv;
	}

	public void setPreGroupDatePv(Long preGroupDatePv) {
		this.preGroupDatePv = preGroupDatePv;
	}

	public double getFlowRate() {
		return flowRate;
	}

	public void setFlowRate(double flowRate) {
		this.flowRate = flowRate;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public Long getOpenPv() {
		return openPv;
	}

	public void setOpenPv(Long openPv) {
		this.openPv = openPv;
	}

	public Long getOpenPv2H() {
		return openPv2H;
	}

	public void setOpenPv2H(Long openPv2H) {
		this.openPv2H = openPv2H;
	}

	public Long getOpenPv24H() {
		return openPv24H;
	}

	public void setOpenPv24H(Long openPv24H) {
		this.openPv24H = openPv24H;
	}
}
