/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.algorithm.flow.filter;

import com.bxm.warcar.algorithm.NumericalModel;
import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.algorithm.config.NumericalConfiguration;
import com.bxm.warcar.algorithm.flow.filter.AbstractFilter;
import com.bxm.warcar.algorithm.utils.DoubleUtils;
import com.bxm.warcar.utils.ListOrderHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClassifyFilter
extends AbstractFilter {
    @Autowired
    private NumericalConfiguration numericalConfiguration;

    @Override
    protected void doFilter(RequestModel requestModel) {
        List<NumericalModel> list = requestModel.getList();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<NumericalModel> testList = new ArrayList<NumericalModel>(list.size());
        ArrayList<NumericalModel> formalList = new ArrayList<NumericalModel>(list.size());
        list.forEach(model -> this.doFilterThreshold((NumericalModel)model, (List<NumericalModel>)testList, (List<NumericalModel>)formalList));
        this.doFilterClickRate(formalList);
        ListOrderHelper.sortList(formalList, (String)"clickRate", (String)"DESC");
        ListOrderHelper.sortList(testList, (String)"clickRate", (String)"DESC");
        requestModel.setFormalList(formalList);
        requestModel.setTestList(testList);
    }

    private void doFilterClickRate(List<NumericalModel> formalList) {
        if (CollectionUtils.isNotEmpty(formalList)) {
            for (NumericalModel model : formalList) {
                if (model.getOpenPv2H() > this.numericalConfiguration.getFormalPv()) {
                    model.setClickRate(model.getClickRate2H());
                    continue;
                }
                if (model.getOpenPv24H() <= this.numericalConfiguration.getFormalPv()) continue;
                model.setClickRate(model.getClickRate24H());
            }
        }
    }

    private void doFilterThreshold(NumericalModel model, List<NumericalModel> testList, List<NumericalModel> formalList) {
        if (model.getOpenPv() <= (long)this.numericalConfiguration.getThreshold1()) {
            testList.add(model);
            return;
        }
        if (model.getOpenPv() <= (long)this.numericalConfiguration.getThreshold2()) {
            double[] dArray = new double[]{model.getGroupClickRate(), this.numericalConfiguration.getClickRate2()};
            if (model.getClickRate() <= DoubleUtils.multiply(dArray)) {
                formalList.add(model);
                return;
            }
            testList.add(model);
            return;
        }
        if (model.getOpenPv() <= (long)this.numericalConfiguration.getThreshold3()) {
            double[] dArray = new double[]{model.getGroupClickRate(), this.numericalConfiguration.getClickRate3()};
            if (model.getClickRate() <= DoubleUtils.multiply(dArray)) {
                formalList.add(model);
                return;
            }
            testList.add(model);
            return;
        }
        formalList.add(model);
    }
}

