package com.bxm.warcar.algorithm.flow;

import com.bxm.warcar.algorithm.flow.filter.AbstractFilter;
import com.bxm.warcar.algorithm.flow.filter.DistributionFilter;
import com.bxm.warcar.algorithm.flow.filter.ClassifyFilter;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/17 13:34
 */
@Component
public class FlowFilterChain implements Interceptor, ApplicationListener<ContextRefreshedEvent> {

	private final List<Interceptor> interceptors = Lists.newArrayList();

	@Autowired
	private ClassifyFilter classifyFilter;
	@Autowired
	private DistributionFilter distributionFilter;

	@Override
	public void intercept(Invocation invocation) {
		interceptors.get(0).intercept(invocation);
	}
	/**
	 * Handle an application event.
	 *
	 * @param event the event to respond to
	 */
	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {
		if(interceptors.size() ==0) {
			addInterceptors();
		}
	}

	private void addInterceptors() {
		interceptors.add(classifyFilter);
		interceptors.add(distributionFilter);
		setChain(interceptors);
	}

	private static void setChain(List<Interceptor> interceptors) {
		// 按添加顺序设置链条
		for (int i = 0; i < interceptors.size(); i++) {
			Interceptor interceptor = interceptors.get(i);
			if (interceptor instanceof AbstractFilter) {
				boolean isLast = i + 1 == interceptors.size();
				if (! isLast) {
					((AbstractFilter) interceptor).setNextInterceptor(interceptors.get(i + 1));
				}
			}
		}
	}
}
