package com.bxm.warcar.algorithm.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * <h3>通用数值配置</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/15 19:07
 */
@Configuration
@ConfigurationProperties(prefix = "warcar.algorithm")
public class NumericalConfiguration {

	/**
	 * 测试流量
	 */
	private double testFlow = 0.2;

	/**
	 * 正式流量
	 */
	private double formalFlow = 0.8;

	/**
	 * 人为参数
	 */
	private double personalFactor =0.8;

	/**
	 * 默认曝光pv
	 */
	private long defaultOpenPv =10000;

	/**
	 * 一级阈值
	 */
	private int threshold1 = 200;

	/**
	 * 二级阈值
	 */
	private int threshold2 =400 ;

	/**
	 * 三级阈值
	 */
	private int threshold3 = 600;

	/**
	 * 二级点击率
	 */
	private double clickRate2 = 0.7;

	/**
	 * 三级点击率
	 */
	private double clickRate3 = 0.85;

	/**
	 * 正式点击
	 */
	private long formalPv = 500;


	public long getDefaultOpenPv() {
		return defaultOpenPv;
	}

	public void setDefaultOpenPv(long defaultOpenPv) {
		this.defaultOpenPv = defaultOpenPv;
	}

	public double getTestFlow() {
		return testFlow;
	}

	public void setTestFlow(double testFlow) {
		this.testFlow = testFlow;
	}

	public double getFormalFlow() {
		return formalFlow;
	}

	public void setFormalFlow(double formalFlow) {
		this.formalFlow = formalFlow;
	}

	public int getThreshold1() {
		return threshold1;
	}

	public void setThreshold1(int threshold1) {
		this.threshold1 = threshold1;
	}

	public int getThreshold2() {
		return threshold2;
	}

	public void setThreshold2(int threshold2) {
		this.threshold2 = threshold2;
	}

	public int getThreshold3() {
		return threshold3;
	}

	public void setThreshold3(int threshold3) {
		this.threshold3 = threshold3;
	}

	public double getClickRate2() {
		return clickRate2;
	}

	public void setClickRate2(double clickRate2) {
		this.clickRate2 = clickRate2;
	}

	public double getClickRate3() {
		return clickRate3;
	}

	public void setClickRate3(double clickRate3) {
		this.clickRate3 = clickRate3;
	}

	public double getPersonalFactor() {
		return personalFactor;
	}

	public void setPersonalFactor(double personalFactor) {
		this.personalFactor = personalFactor;
	}

	public long getFormalPv() {
		return formalPv;
	}

	public void setFormalPv(long formalPv) {
		this.formalPv = formalPv;
	}
}
