package com.bxm.warcar.algorithm.flow.filter;

import com.bxm.warcar.algorithm.config.Constant;
import com.bxm.warcar.algorithm.config.NumericalConfiguration;
import com.bxm.warcar.algorithm.NumericalModel;
import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.algorithm.utils.DoubleUtils;
import com.bxm.warcar.utils.ListOrderHelper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>过滤测试与正式数据 分类</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/17 13:37
 */
@Component
public class ClassifyFilter extends AbstractFilter {

	@Autowired
	private NumericalConfiguration numericalConfiguration;
	/**
	 * 业务处理
	 * @param requestModel
	 */
	@Override
	protected void doFilter(RequestModel requestModel) {

		List<NumericalModel> list = requestModel.getList();
		if (CollectionUtils.isEmpty(list)){
			return ;
		}

		List<NumericalModel> testList = new ArrayList<>(list.size());
		List<NumericalModel> formalList = new ArrayList<>(list.size());

		// 1，判断曝光属于几级阈值 1：0-200   2：200-400  3 ：400-600 4:600+
		list.forEach( model -> doFilterThreshold(model,testList,formalList));

		//处理2H，24H 点击与点击率
		doFilterClickRate(formalList);

		ListOrderHelper.sortList(formalList,Constant.CLICKRATE, Constant.DESC);
		ListOrderHelper.sortList(testList,Constant.CLICKRATE, Constant.DESC);

		requestModel.setFormalList(formalList);
		requestModel.setTestList(testList);
	}


	private void doFilterClickRate(List<NumericalModel> formalList){
		if (CollectionUtils.isNotEmpty(formalList)){
			for(NumericalModel model:formalList){
				if (model.getOpenPv2H()>numericalConfiguration.getFormalPv()){
					model.setClickRate(model.getClickRate2H());
					continue;
				}
				if (model.getOpenPv24H()>numericalConfiguration.getFormalPv()){
					model.setClickRate(model.getClickRate24H());
					continue;
				}
			}
		}

	}

	/**
	 * 过滤测试与正式数据
	 * @param model
	 * @param testList
	 * @param formalList
	 */
	private void doFilterThreshold(NumericalModel model, List<NumericalModel> testList, List<NumericalModel> formalList){
		// 判断曝光属于几级阈值 1：0-200
		if (model.getOpenPv()<= numericalConfiguration.getThreshold1()){
			testList.add(model);
			return;
		}

		// 判断曝光属于几级阈值   2：200-400
		if (model.getOpenPv()<= numericalConfiguration.getThreshold2()){
			if (model.getClickRate()<= DoubleUtils.multiply(model.getGroupClickRate(), numericalConfiguration.getClickRate2())){
				// 小于二级阈值的点击比率
				formalList.add(model);
				return;
			}
			testList.add(model);
			return;
		}

		// 判断曝光属于几级阈值  3 ：400-600
		if(model.getOpenPv()<= numericalConfiguration.getThreshold3()){
			if (model.getClickRate()<=DoubleUtils.multiply(model.getGroupClickRate(), numericalConfiguration.getClickRate3())){
				// 小于三级阈值的点击比率
				formalList.add(model);
				return;
			}
			testList.add(model);
			return;
		}
		// 判断曝光属于几级阈值  4:600+
		formalList.add(model);
	}

}
