/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.aspect;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAspect {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String SESSION_USER_NAME = "user_name";

    protected String convent(Object args) {
        try {
            return JSONObject.toJSONString((Object)args);
        }
        catch (Exception e) {
            return "";
        }
    }

    protected long excTime(long startTime) {
        long endTime = System.currentTimeMillis();
        return (endTime - startTime) / 1000L;
    }

    protected Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected String getUser(JoinPoint point) {
        try {
            Object[] args = point.getArgs();
            HttpServletRequest request = null;
            if (ArrayUtils.isNotEmpty((Object[])args)) {
                for (Object arg : args) {
                    if (!(arg instanceof HttpServletRequest)) continue;
                    request = (HttpServletRequest)arg;
                    break;
                }
            }
            if (request != null) {
                return (String)request.getAttribute(SESSION_USER_NAME);
            }
        }
        catch (Exception e) {
            this.logger.error("get user is null", (Object)e.getMessage());
        }
        return "-";
    }

    protected String getParams(JoinPoint point) {
        Object[] args = point.getArgs();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        StringBuffer sb = new StringBuffer();
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; i < args.length; ++i) {
                sb.append(this.convent(parameterNames[i])).append(":").append(this.convent(args[i])).append(";");
            }
        }
        return sb.toString();
    }
}

